/* This program transfers a .prg file from a PC to a C64 using the PC's
   parallel port and the C64's user port. To use, enter: x64 filename.prg
   on the PC after the C64 is waiting for the file.

   Transfer protocol: The PC waits for the *BUSY line to drop before sending
   a byte. When it detects the fall, it places the byte onto the port and
   toggles STROBE (D4 on the parallel port). It then waits for the C64
   to raise the *BUSY signal. The PC acknowledges the transition by
   toggling STROBE again. Note that the BUSY signal is inverted.
*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>

/* #define lpt2 0x3bc */
#define lpt1 0x378

/* PC->C64 */
#define STROBE 0x10
#define BUSY 0x80

void init_port(void);
void txbyte(unsigned char);
unsigned char rxbyte(void);

void main(int argc, char *argv[])
{
	FILE *fp;
	unsigned char ch;

	init_port();

	if (argc!=2) {
		printf("Usage: x64 fname.prg\n");
		exit(0);
	}

	fp = fopen(argv[1],"rb");
	while(!feof(fp)) {
		ch=(unsigned char) fgetc(fp);
		txbyte(ch);      /* Read byte and tx */
		if (ch==0x03)
		  txbyte(ch);   /* Send twice */
	}
	fclose(fp);
	ch=0x03;
	txbyte(ch);
	ch=0x00;
	txbyte(ch);
}

void init_port(void)
{
	outportb(lpt1+2, 0x04);
	outportb(lpt1, STROBE)
}

void txbyte(unsigned char ch)
{
	ch ^= 0x0b;
	while((inportb(lpt1+1) & BUSY));    /* Wait for *BUSY release */
	outportb(lpt1+2,ch);         /* Present MSB */
	outportb(lpt1,(ch / 16) & 0x0f);        /* LSB + STROBE */
	outportb(lpt1, (ch / 16) | STROBE); /* Pull Strobe high */
	while(!(inportb(lpt1+1) & BUSY));    /* Wait for *BUSY release */
	outportb(lpt1, 0);              /* Toggle STROBE */
	outportb(lpt1, STROBE);
}

